# Moltbot Trading System - Setup Package

## What This Is

Autonomous SPY trading system running on WSL2 (Ubuntu on Windows 11). Uses sentiment scoring to buy dips and ride momentum, with hard-coded risk controls.

## Package Contents

| File | Purpose |
|------|---------|
| `moltbot-setup.sh` | Automated installer/restorer |
| `moltbot-backup-YYYYMMDD.tar.gz` | Your workspace backup (scripts, configs, logs) |
| `README.md` | This file |

## Quick Start (New Machine)

1. **Windows PowerShell (Admin):** `wsl --install` → Reboot
2. **Open Ubuntu**, create username/password
3. Copy `moltbot-setup.sh` and `moltbot-backup-*.tar.gz` to `\\wsl$\Ubuntu\home\USERNAME\`
4. In Ubuntu: `chmod +x moltbot-setup.sh && ./moltbot-setup.sh`
5. Follow the manual steps printed at the end

## Quick Start (Restore on Existing Machine)

Same as above — script detects the backup and restores instead of fresh install.

## Per-User Configuration

These must be changed for each user/machine:

| Item | Where | What to Change |
|------|-------|----------------|
| Robinhood credentials | `~/moltbot-research/.env` | Username, password |
| Anthropic API key | `~/.openclaw/openclaw.json` | Your API key |
| ntfy topic | Script prompts during setup | Unique topic name |
| User profile | `~/moltbot-research/USER.md` | Name, timezone |
| Robinhood account | robinhood.com | Dedicated account, funded, bank unlinked |

## Risk Controls (Hard-Coded)

- Max position: $750
- Max daily trades: 5
- Stop loss: 3%
- Take profit: 5%
- Daily loss limit: $50
- Kill switch: `touch ~/moltbot-research/HALT`
- Buy cutoff: 12:45 PM local time
- PDT protection: max 3 day trades per 5 days

## Schedule (Weekdays Only)

| Time (AZ/MST) | What |
|----------------|------|
| 6:00 AM | Pre-market weather report |
| 6:30 AM | Market open, scanner starts |
| Every 15 min | Score check, trade if threshold hit |
| 2:00 PM | Market close summary |

## Security Model

"Untrusted employee" — the AI agent can browse the web and write files to one folder. It cannot access Windows files, send emails, use messaging, or install software. You review all output from the Windows side.

## Emergency

```bash
# Stop all trading immediately
touch ~/moltbot-research/HALT

# Resume trading
rm ~/moltbot-research/HALT

# Check status
cd ~/moltbot-research && python3 spy_trader.py status

# Kill WSL2 entirely (from Windows PowerShell)
wsl --shutdown
```
