#!/bin/bash
# Scanner Setup - Run this once to install and configure
# Usage: bash setup_scanner.sh

echo "=== Market Scanner Setup ==="

# 1. Install yfinance
echo ""
echo "Installing yfinance..."
pip3 install yfinance --break-system-packages -q
if [ $? -eq 0 ]; then
    echo "✓ yfinance installed"
else
    echo "✗ yfinance install failed"
    exit 1
fi

# 2. Test the scanner
echo ""
echo "Testing scanner (forced, outside market hours OK)..."
cd ~/moltbot-research
python3 market_scanner.py --force
if [ $? -eq 0 ]; then
    echo "✓ Scanner works"
else
    echo "✗ Scanner test failed - check errors above"
    exit 1
fi

# 3. Set up cron
echo ""
echo "Setting up cron schedule..."
echo "Schedule: Every 15 min, 6:00 AM - 1:00 PM AZ, Monday-Friday"
echo ""

# Check if cron entry already exists
CRON_LINE="*/15 6-13 * * 1-5 cd /home/mm/moltbot-research && /usr/bin/python3 market_scanner.py >> /home/mm/moltbot-research/scanner_cron.log 2>&1"

(crontab -l 2>/dev/null | grep -v "market_scanner.py"; echo "$CRON_LINE") | crontab -

echo "✓ Cron installed"
echo ""

# 4. Verify
echo "Current crontab:"
crontab -l
echo ""
echo "=== Setup Complete ==="
echo ""
echo "What happens now:"
echo "  - Every 15 min during market hours, scanner fetches SPY + VIX"
echo "  - Scores signal quantitatively (no API tokens burned)"
echo "  - Writes to signals.md and scanner_log.csv"
echo "  - If score hits +3 or -3: sends ntfy alert to your phone"
echo "  - You open Moltbot only when there's a decision to make"
echo ""
echo "Manual commands:"
echo "  python3 market_scanner.py --force    # Run scan now"
echo "  cat signals.md                       # View latest signals"
echo "  cat scanner_log.csv                  # View scan history"
echo "  crontab -r                           # Remove all cron jobs"
echo ""
echo "IMPORTANT: WSL2 cron service may need starting:"
echo "  sudo service cron start"
echo "  sudo service cron status"
